<?php
if (!defined('_PS_VERSION_')) { exit; }

class AdminWhatsboostStatusController extends ModuleAdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->ajax = true;
    }

    public function ajaxProcessStatus()
    {
        header('Content-Type: application/json; charset=utf-8');
        $secret = (string)Configuration::get('WHATSBOOST_SECRET');
        $verified = (int)Configuration::get('WHATSBOOST_VERIFIED');
        $unique = (string)Configuration::get('WHATSBOOST_UNIQUE');
        $needsUnique = (int)Configuration::get('WHATSBOOST_NEEDS_UNIQUE');

        $showKey = ($secret === '' || !$verified) ? 1 : 0;
        $showUnique = ($secret !== '' && $verified && (($needsUnique === 1) || $unique === '')) ? 1 : 0;
        $showOk = ($secret !== '' && $verified && $unique !== '' && (int)$needsUnique === 0) ? 1 : 0;

        die(json_encode([
            'ok' => true,
            'show_key' => (int)$showKey,
            'show_unique' => (int)$showUnique,
            'secret_present' => $secret !== '' ? 1 : 0,
            'verified' => (int)$verified,
            'unique_present' => ($unique !== '') ? 1 : 0,
            'needs_unique' => (int)$needsUnique,
            'show_ok' => (int)$showOk,
        ]));
    }
}
