<?php
if (!defined('_PS_VERSION_')) { exit; }

class WhatsboostAccountsModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        parent::initContent();

        header('Content-Type: application/json; charset=utf-8');

        $secret = (string)Configuration::get('WHATSBOOST_SECRET');
        if ($secret === '') {
            die(json_encode([
                'ok' => false,
                'message' => 'No hay clave guardada',
                'accounts' => [],
                'raw' => null,
            ]));
        }

        $url = 'https://whatsboost.net/api/get/wa.accounts?secret=' . urlencode($secret) . '&limit=10&page=1';
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HEADER => false,
            CURLOPT_CONNECTTIMEOUT => 5,
            CURLOPT_TIMEOUT => 10,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_MAXREDIRS => 3,
            CURLOPT_HTTPHEADER => [
                'Accept: application/json',
                'User-Agent: PrestaShop-WhatsBoost/' . $this->module->version,
            ],
            CURLOPT_SSL_VERIFYPEER => true,
            CURLOPT_SSL_VERIFYHOST => 2,
        ]);
        $body = curl_exec($ch);
        $errno = curl_errno($ch);
        $error = curl_error($ch);
        $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($errno) {
            die(json_encode([
                'ok' => false,
                'message' => 'cURL ' . (int)$errno . ': ' . $error,
                'accounts' => [],
                'raw' => null,
            ]));
        }

        if ((int)$code !== 200) {
            die(json_encode([
                'ok' => false,
                'message' => 'HTTP ' . (int)$code,
                'accounts' => [],
                'raw' => (string)$body,
            ]));
        }

        $decoded = json_decode((string)$body, true);
        $accounts = [];
        if (is_array($decoded)) {
            $d = isset($decoded['data']) ? $decoded['data'] : null;
            if (is_array($d) && isset($d['data'])) { $d = $d['data']; }
            if (isset($d['unique'])) {
                $accounts[] = [
                    'id' => isset($d['id']) ? (int)$d['id'] : null,
                    'phone' => isset($d['phone']) ? (string)$d['phone'] : '',
                    'unique' => isset($d['unique']) ? (string)$d['unique'] : '',
                    'status' => isset($d['status']) ? (string)$d['status'] : '',
                ];
            } elseif (is_array($d)) {
                foreach ($d as $item) {
                    if (!is_array($item)) continue;
                    $accounts[] = [
                        'id' => isset($item['id']) ? (int)$item['id'] : null,
                        'phone' => isset($item['phone']) ? (string)$item['phone'] : '',
                        'unique' => isset($item['unique']) ? (string)$item['unique'] : '',
                        'status' => isset($item['status']) ? (string)$item['status'] : '',
                    ];
                }
            }
        }

        die(json_encode([
            'ok' => true,
            'accounts' => $accounts,
            'raw' => $decoded,
        ]));
    }
}

