﻿
{* Estados y pedidos con soporte i18n ES/EN y textos traducibles con {l} *}
<div class="wb-card">
  <div class="wb-alert wb-alert--info" style="margin-bottom:12px">
    <strong data-i18n="states.how.title">{l s='Cómo funciona esta página:' mod='whatsboost'}</strong>
    <span data-i18n="states.how.desc">{l s='Aquí puedes decidir en qué estados de pedido se enviarán mensajes por WhatsApp y qué texto se enviará.' mod='whatsboost'}</span>
    <ol style="margin:8px 0 0 18px">
      <li data-i18n="states.how.step1">{l s='Marca (activa) los estados donde quieres enviar el mensaje. Ejemplo: Procesando, Completado.' mod='whatsboost'}</li>
      <li data-i18n="states.how.step2">{l s='Escribe el mensaje en la caja de texto de cada estado. Puedes usar etiquetas como {nombre}, {producto_pedido}, {precio}.' mod='whatsboost'}</li>
      <li data-i18n="states.how.step3">{l s='Pulsa Guardar cambios al final para que quede guardado.' mod='whatsboost'}</li>
      <li data-i18n="states.how.step4">{l s='Cuando un pedido cambie a ese estado, el módulo preparará el mensaje con los datos reales y lo enviará según tu configuración.' mod='whatsboost'}</li>
    </ol>
    <p style="margin:8px 0 0" data-i18n="states.how.tip">{l s='Consejo: a la derecha tienes un listado de etiquetas con botón de copiar.' mod='whatsboost'}</p>
  </div>

  <h3 class="wb-card-title" data-i18n="states.title">{l s='Bienvenido a WhatsBoost' mod='whatsboost'}</h3>

  <div class="wb-grid wb-grid--states" style="margin-top:10px">
    <div class="wb-col">
      <form method="post" action="{$admin_base|escape:'htmlall':'UTF-8'}&wbv=states">
        <input type="hidden" name="submitWhatsboostStates" value="1" />

        <div class="wb-table-wrap">
          <table class="table" style="width:100%">
            <thead>
            <tr>
              <th style="width:30%" data-i18n="states.th.name">{l s='Nombre' mod='whatsboost'}</th>
              <th style="width:10%" data-i18n="states.th.state">{l s='Estado' mod='whatsboost'}</th>
              <th style="width:60%" data-i18n="states.th.text">{l s='Texto' mod='whatsboost'}</th>
            </tr>
            </thead>
            <tbody>
            {if isset($order_states) && $order_states|@count > 0}
              {foreach from=$order_states item=os}
                {assign var=sid value=$os.id_order_state}
                {assign var=cfg value=$states_cfg[$sid]|default:[]}
                <tr>
                  <td><strong>{$os.name|escape:'htmlall':'UTF-8'}</strong></td>
                  <td style="text-align:center;vertical-align:top">
                    <input type="checkbox" name="states[{$sid|escape:'htmlall':'UTF-8'}][enabled]" {if isset($cfg.enabled) && $cfg.enabled}checked{/if} aria-label="{l s='Activar envío para este estado' mod='whatsboost'}" />
                  </td>
                  <td>
                    <textarea class="wb-input" name="states[{$sid|escape:'htmlall':'UTF-8'}][text]" rows="2" placeholder="{l s='Escribe aquí el texto para este estado...' mod='whatsboost'}" data-i18n-ph="states.placeholder">{if isset($cfg.text)}{$cfg.text|escape:'htmlall':'UTF-8'}{/if}</textarea>
                  </td>
                </tr>
              {/foreach}
            {else}
              <tr><td colspan="3" data-i18n="states.empty">{l s='No se encontraron estados de pedido.' mod='whatsboost'}</td></tr>
            {/if}
            </tbody>
          </table>
        </div>

        <div class="wb-actions" style="margin-top:10px">
          <button type="submit" class="wb-btn wb-btn-primary" data-i18n="states.save">{l s='Guardar cambios' mod='whatsboost'}</button>
        </div>
      </form>
    </div>

    <aside class="wb-col wb-aside-help">
      <div class="wb-card">
        <h3 class="wb-card-title" data-i18n="help.title">{l s='Ayuda rápida: etiquetas y botón de copiar' mod='whatsboost'}</h3>
        <p class="wb-subtle" data-i18n="help.desc">{l s='Abajo tienes todas las etiquetas explicadas. Para copiar una, pulsa el botón pequeño con el icono de copiar y luego pégala en el texto de la izquierda. El módulo la cambia por el dato real al enviar.' mod='whatsboost'}</p>

        <ul class="wb-subtle wb-help-list" style="list-style:none;padding:0;margin:8px 0">
          <li class="wb-help-item"><code>&#123;nombre&#125;</code><span data-i18n="token.name"> - {l s='Nombre del cliente.' mod='whatsboost'}</span><button type="button" class="wb-copy" data-token="&#123;nombre&#125;"><span class="wb-sr" data-i18n="copy.btn">{l s='Copiar' mod='whatsboost'}</span><svg viewBox="0 0 24 24" aria-hidden="true"><path d="M16 1H4c-1.1 0-2 .9-2 2v12h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"/></svg></button></li>
          <li class="wb-help-item"><code>&#123;apellido&#125;</code><span data-i18n="token.lastname"> - {l s='Apellido del cliente.' mod='whatsboost'}</span><button type="button" class="wb-copy" data-token="&#123;apellido&#125;"><span class="wb-sr" data-i18n="copy.btn">{l s='Copiar' mod='whatsboost'}</span><svg viewBox="0 0 24 24" aria-hidden="true"><path d="M16 1H4c-1.1 0-2 .9-2 2v12h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"/></svg></button></li>
          <li class="wb-help-item"><code>&#123;producto_pedido&#125;</code><span data-i18n="token.product"> - {l s='Nombre del primer producto del pedido.' mod='whatsboost'}</span><button type="button" class="wb-copy" data-token="&#123;producto_pedido&#125;"><span class="wb-sr" data-i18n="copy.btn">{l s='Copiar' mod='whatsboost'}</span><svg viewBox="0 0 24 24" aria-hidden="true"><path d="M16 1H4c-1.1 0-2 .9-2 2v12h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"/></svg></button></li>
          <li class="wb-help-item"><code>&#123;cantidad&#125;</code><span data-i18n="token.qty"> - {l s='Cantidad del primer producto.' mod='whatsboost'}</span><button type="button" class="wb-copy" data-token="&#123;cantidad&#125;"><span class="wb-sr" data-i18n="copy.btn">{l s='Copiar' mod='whatsboost'}</span><svg viewBox="0 0 24 24" aria-hidden="true"><path d="M16 1H4c-1.1 0-2 .9-2 2v12h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"/></svg></button></li>
          <li class="wb-help-item"><code>&#123;precio&#125;</code><span data-i18n="token.total"> - {l s='Total del pedido con moneda.' mod='whatsboost'}</span><button type="button" class="wb-copy" data-token="&#123;precio&#125;"><span class="wb-sr" data-i18n="copy.btn">{l s='Copiar' mod='whatsboost'}</span><svg viewBox="0 0 24 24" aria-hidden="true"><path d="M16 1H4c-1.1 0-2 .9-2 2v12h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"/></svg></button></li>
          <li class="wb-help-item"><code>&#123;plazo&#125;</code><span data-i18n="token.shipping"> - {l s='Método de envío o plazo.' mod='whatsboost'}</span><button type="button" class="wb-copy" data-token="&#123;plazo&#125;"><span class="wb-sr" data-i18n="copy.btn">{l s='Copiar' mod='whatsboost'}</span><svg viewBox="0 0 24 24" aria-hidden="true"><path d="M16 1H4c-1.1 0-2 .9-2 2v12h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"/></svg></button></li>
          <li class="wb-help-item"><code>&#123;tienda"/></code><span data-i18n="token.store"> - {l s='Nombre de tu tienda o marca.' mod='whatsboost'}</span><button type="button" class="wb-copy" data-token="&#123;tienda"/><span class="wb-sr" data-i18n="copy.btn">{l s='Copiar' mod='whatsboost'}</span><svg viewBox="0 0 24 24" aria-hidden="true"><path d="M16 1H4c-1.1 0-2 .9-2 2v12h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"/></svg></button></li>
          <li class="wb-help-item"><code>&#123;link"/></code><span data-i18n="token.link"> - {l s='Enlace para ver el pedido.' mod='whatsboost'}</span><button type="button" class="wb-copy" data-token="&#123;link"/><span class="wb-sr" data-i18n="copy.btn">{l s='Copiar' mod='whatsboost'}</span><svg viewBox="0 0 24 24" aria-hidden="true"><path d="M16 1H4c-1.1 0-2 .9-2 2v12h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"/></svg></button></li>
          <li class="wb-help-item"><code>&#123;order_number&#125;</code><span data-i18n="token.ordernum"> - {l s='Número del pedido (p. ej., #123).' mod='whatsboost'}</span><button type="button" class="wb-copy" data-token="&#123;order_number"/><span class="wb-sr" data-i18n="copy.btn">{l s='Copiar' mod='whatsboost'}</span><svg viewBox="0 0 24 24" aria-hidden="true"><path d="M16 1H4c-1.1 0-2 .9-2 2v12h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"/></svg></button></li>
          <li class="wb-help-item"><code>&#123;tracking"/></code><span data-i18n="token.tracking"> - {l s='Enlace o código de seguimiento (si existe).' mod='whatsboost'}</span><button type="button" class="wb-copy" data-token="&#123;tracking"/><span class="wb-sr" data-i18n="copy.btn">{l s='Copiar' mod='whatsboost'}</span><svg viewBox="0 0 24 24" aria-hidden="true"><path d="M16 1H4c-1.1 0-2 .9-2 2v12h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"/></svg></button></li>
        </ul>

        <h4 class="wb-card-title" style="margin-top:10px" data-i18n="rules.title">{l s='Reglas rápidas' mod='whatsboost'}</h4>
        <ul class="wb-subtle" style="margin:6px 0 0 16px">
          <li data-i18n="rules.rule1">{l s='No uses corchetes [ ]. Usa llaves { }.' mod='whatsboost'}</li>
          <li data-i18n="rules.rule2">{l s='No dejes llaves vacías. Si no tienes el dato, borra esa parte.' mod='whatsboost'}</li>
          <li><code>&#123;link&#125;</code> <span data-i18n="rules.rule3">{l s='debe abrir correctamente.' mod='whatsboost'}</span></li>
        </ul>

        <h4 class="wb-card-title" style="margin-top:12px" data-i18n="example.title.in">{l s='Ejemplo mínimo (lo que escribes)' mod='whatsboost'}</h4>
        <textarea class="wb-pre" readonly rows="4" style="width:100%" data-i18n="example.text.in">{l s='Hola {nombre} Tu {producto_pedido} ({cantidad}) está en proceso. Mira aquí: {link}' mod='whatsboost'}</textarea>

        <h4 class="wb-card-title" style="margin-top:12px" data-i18n="example.title.out">{l s='Resultado de ese ejemplo (lo que verá el cliente)' mod='whatsboost'}</h4>
        <textarea class="wb-pre" readonly rows="4" style="width:100%" data-i18n="example.text.out">{l s='Hola Laura Tu guantes térmicos (x2) está en proceso. Mira aquí:' mod='whatsboost'}
https://mi-tienda.com/pedido/123</textarea>
      </div>
    </aside>
  </div>
</div>

{literal}
  <script>
    (function(){
      var lastTA = null;
      document.addEventListener('focusin', function(e){
        if(e.target && e.target.tagName==='TEXTAREA'){ lastTA = e.target; }
      });
      var btns = document.querySelectorAll('.wb-copy');
      for(var i=0;i<btns.length;i++){
        btns[i].addEventListener('click', function(){
          var token = (this.getAttribute('data-token')||'').replace(/&#123;/g,'{').replace(/&#125;/g,'}');
          if(lastTA){
            var s = lastTA.selectionStart||lastTA.value.length;
            var e = lastTA.selectionEnd||lastTA.value.length;
            var v = lastTA.value;
            lastTA.value = v.slice(0,s) + token + v.slice(e);
            try{ lastTA.focus(); lastTA.selectionStart = lastTA.selectionEnd = s + token.length; }catch(err){}
          }
          try{ if(navigator.clipboard){ navigator.clipboard.writeText(token); } }catch(err){}
          this.classList.add('is-copied');
          var self = this;
          setTimeout(function(){ self.classList.remove('is-copied'); }, 900);
        });
      }

      // Runtime i18n for EN
      try{
        var lang = (document.documentElement.getAttribute('lang')||'').toLowerCase();
        if(lang.indexOf('en') === 0){
          var t = {
            'states.how.title': 'How this page works:',
            'states.how.desc': 'Here you can choose in which order states WhatsApp messages will be sent and what text will be used.',
            'states.how.step1': 'Check (enable) the states where you want to send the message. Example: Processing, Completed.',
            'states.how.step2': 'Write the message in the text box for each state. You can use tokens like {nombre}, {producto_pedido}, {precio}.',
            'states.how.step3': 'Click Save changes at the bottom to store it.',
            'states.how.step4': 'When an order changes to that state, the module will prepare the message with real data and send it according to your settings.',
            'states.how.tip': 'Tip: on the right you have a list of tokens with copy button.',
            'states.title': 'Welcome to WhatsBoost',
            'states.th.name': 'Name',
            'states.th.state': 'State',
            'states.th.text': 'Text',
            'states.empty': 'No order states found.',
            'states.save': 'Save changes',
            'states.placeholder': 'Write here the text for this state...',
            'help.title': 'Quick help: tokens and copy button',
            'help.desc': 'Below you have all tokens explained. To copy one, click the small button with the copy icon and then paste it into the text on the left. The module replaces it with the real data when sending.',
            'copy.btn': 'Copy',
            'token.name': ' - Customer first name.',
            'token.lastname': ' - Customer last name.',
            'token.product': ' - Name of the first product in the order.',
            'token.qty': ' - Quantity of the first product.',
            'token.total': ' - Order total with currency.',
            'token.shipping': ' - Shipping method or lead time.',
            'token.store': ' - Your shop or brand name.',
            'token.link': ' - Link to view the order.',
            'token.ordernum': ' - Order number (e.g., #123).',
            'token.tracking': ' - Tracking link or code (if available).',
            'rules.title': 'Quick rules',
            'rules.rule1': 'Do not use brackets [ ]. Use braces { }.',
            'rules.rule2': 'Do not leave empty braces. If you don\'t have the data, remove that part.',
            'rules.rule3': 'must open correctly.',
            'example.title.in': 'Minimal example (what you write)',
            'example.text.in': 'Hello {nombre} Your {producto_pedido} ({cantidad}) is being processed. See here: {link}',
            'example.title.out': 'Result of that example (what the customer will see)',
            'example.text.out': 'Hello Laura Your thermal gloves (x2) are being processed. See here:'
          };

          document.querySelectorAll('[data-i18n]').forEach(function(el){
            var k = el.getAttribute('data-i18n');
            if(t[k]){ el.textContent = t[k]; }
          });
          document.querySelectorAll('[data-i18n-ph]').forEach(function(el){
            var k = el.getAttribute('data-i18n-ph');
            if(t[k]){ el.setAttribute('placeholder', t[k]); }
          });
        }
      }catch(e){}
    })();
  </script>
{/literal}





