{* Admin layout wrapper with tabs (styled like ficheros/*.php) *}
<div class="whatsboost-admin">
  <div class="wrap">
    <div class="wb-sticky-header">
      <header class="whatsboost-settings-header">
        <div class="whatsboost-brand">
          <img class="wb-header-logo" src="{$module_dir|escape:'htmlall':'UTF-8'}views/img/logo-dark.png" alt="{l s='WhatsBoost' mod='whatsboost'}" />
          <div class="wb-header-actions">
            <a class="wb-btn wb-btn-secondary" href="https://whatsboost.net/" target="_blank" rel="noopener noreferrer" data-i18n="layout.goto">{l s='Ir a WhatsBoost' mod='whatsboost'}</a>
            <a class="wb-btn wb-btn-secondary" href="https://whatsboost.net/dashboard/auth" target="_blank" rel="noopener noreferrer" data-i18n="layout.login">{l s='Iniciar sesión' mod='whatsboost'}</a>
            <a class="wb-btn wb-btn-primary" href="https://whatsboost.net/dashboard/auth/register" target="_blank" rel="noopener noreferrer" data-i18n="layout.register">{l s='Registrarse' mod='whatsboost'}</a>
          </div>
        </div>
      </header>

      <nav class="wb-tabs">
      <a class="wb-tab{if $view=='welcome'} is-active{/if}" href="{$admin_base|escape:'htmlall':'UTF-8'}&wbv=welcome" data-i18n="layout.tab.welcome">{l s='Bienvenida' mod='whatsboost'}</a>
      <a class="wb-tab{if $view=='settings'} is-active{/if}" href="{$admin_base|escape:'htmlall':'UTF-8'}&wbv=settings" data-i18n="layout.tab.settings">{l s='Ajustes' mod='whatsboost'}</a>
      <a class="wb-tab{if $view=='states'} is-active{/if}" href="{$admin_base|escape:'htmlall':'UTF-8'}&wbv=states" data-i18n="layout.tab.states">{l s='Estados y pedidos' mod='whatsboost'}</a>
      <a class="wb-tab{if $view=='docs'} is-active{/if}" href="{$admin_base|escape:'htmlall':'UTF-8'}&wbv=docs" data-i18n="layout.tab.docs">{l s='Documentos' mod='whatsboost'}</a>
      </nav>
    </div>

    {if isset($invalid_secret) && $invalid_secret}
      <div id="wb_invalid_secret" class="wb-alert wb-alert--danger" role="alert" style="margin:8px 0 0">
        {$invalid_secret_msg|escape:'htmlall':'UTF-8'}
      </div>
    {/if}

    <section class="wb-content">
      {if $view=='welcome'}
        {include file='module:whatsboost/views/templates/admin/welcome.tpl'}
      {elseif $view=='docs'}
        {include file='module:whatsboost/views/templates/admin/documentos.tpl'}
      {elseif $view=='states'}
        {include file='module:whatsboost/views/templates/admin/estados-pedidos.tpl'}
      {else}
        {include file='module:whatsboost/views/templates/admin/settings.tpl'}
      {/if}
    </section>

    <footer class="whatsboost-footer">
      <div class="wb-footer-inner">
        <div class="wb-footer-left">
          <img class="wb-footer-logo" src="{$module_dir|escape:'htmlall':'UTF-8'}views/img/almc-logo.webp" alt="{l s='Logo' mod='whatsboost'}" loading="lazy" />
        </div>
        <div class="wb-footer-right">
          <div class="wb-footer-links">
            <a href="https://almc.es/en/sobre-nosotros" rel="nofollow noopener" data-i18n="layout.footer.about">{l s='Nosotros' mod='whatsboost'}</a>
            <span class="wb-footer-sep">•</span>
            <a href="https://almc.es/es/privacidad" rel="nofollow noopener" data-i18n="layout.footer.privacy">{l s='Política de privacidad' mod='whatsboost'}</a>
            <span class="wb-footer-sep">•</span>
            <a href="https://almc.es/es/terminos-condiciones" rel="nofollow noopener" data-i18n="layout.footer.terms">{l s='Términos del servicio' mod='whatsboost'}</a>
          </div>
          <small class="wb-footer-copy">© {date('Y')} WhatsBoost</small>
        </div>
      </div>
    </footer>
  </div>

  {literal}
  <script>
    (function(){
      var scope = document.querySelector('.whatsboost-admin');
      if(!scope){return;}
      var imgs = scope.querySelectorAll('.whatsboost-docs-callout img');
      if(!imgs.length){return;}

      var overlay = document.createElement('div');
      overlay.className = 'whatsboost-lightbox-overlay';
      overlay.setAttribute('role','dialog');
      overlay.setAttribute('aria-modal','true');
      overlay.setAttribute('aria-hidden','true');

      var big = document.createElement('img');
      big.className = 'whatsboost-lightbox-img';
      big.alt = '';

      var closeBtn = document.createElement('button');
      closeBtn.type = 'button';
      closeBtn.className = 'whatsboost-lightbox-close';
      closeBtn.textContent = 'Cerrar (Esc)';

      overlay.appendChild(big);
      overlay.appendChild(closeBtn);
      // Append overlay inside module scope so CSS descendant selectors apply
      scope.appendChild(overlay);

      function open(src, alt){
        big.src = src; if(alt){ big.alt = alt; }
        overlay.classList.add('is-open');
        overlay.setAttribute('aria-hidden','false');
        document.addEventListener('keydown', onKey);
      }
      function close(){
        overlay.classList.remove('is-open');
        overlay.setAttribute('aria-hidden','true');
        big.removeAttribute('src');
        document.removeEventListener('keydown', onKey);
      }
      function onKey(e){ if(e.key==='Escape'){ close(); } }

      overlay.addEventListener('click', function(e){
        if(e.target===overlay || e.target===closeBtn){ close(); }
      });
      big.addEventListener('click', function(e){ e.stopPropagation(); });
      imgs.forEach(function(img){ img.addEventListener('click', function(){ open(img.src, img.alt||''); }); });
    })();
  </script>
  {/literal}

</div>
  {literal}
  <script>
    (function(){
      // Feature-flagged: only auto-calculate sticky offset if explicitly enabled
      var host = document.querySelector('.whatsboost-admin');
      if(!host || !host.hasAttribute('data-auto-sticky')){ return; }

      function setStickyTop(){
        try {
          var head = document.querySelector('.page-head');
          if(head){
            var h = head.offsetHeight || head.getBoundingClientRect().height || 0;
            host.style.setProperty('--wb-sticky-top', (Math.round(h))+'px');
          }
        } catch(e){}
      }
      if(document.readyState==='loading'){
        document.addEventListener('DOMContentLoaded', setStickyTop);
      } else {
        setStickyTop();
      }
      window.addEventListener('resize', setStickyTop);
    })();
  </script>
  {/literal}
{literal}
<script>
(function(){
  try{
    var lang = (document.documentElement.getAttribute('lang')||'').toLowerCase();
    if(lang.indexOf('en') !== 0){ return; }
    var t = {
      'layout.goto': 'Go to WhatsBoost',
      'layout.login': 'Log in',
      'layout.register': 'Sign up',
      'layout.tab.welcome': 'Welcome',
      'layout.tab.settings': 'Settings',
      'layout.tab.states': 'States and orders',
      'layout.tab.docs': 'Documents',
      'layout.footer.about': 'About us',
      'layout.footer.privacy': 'Privacy policy',
      'layout.footer.terms': 'Terms of service'
    };
    document.querySelectorAll('.whatsboost-admin [data-i18n]').forEach(function(el){
      var k = el.getAttribute('data-i18n');
      if(t[k]){ el.textContent = t[k]; }
    });
    var btn = document.querySelector('.whatsboost-admin .whatsboost-lightbox-close');
    if(btn){ btn.textContent = 'Close (Esc)'; }
  }catch(e){}
})();
</script>
{/literal}
