{* Welcome / Onboarding - bonito, profesional y ligero, con i18n runtime ES/EN *}
{if !isset($img_base)}{assign var=img_base value=$module_dir|cat:'views/img/' }{/if}

<div class="porto-admin-card whatsboost-welcome">
  <h2 class="whatsboost-docs-h2" style="margin-bottom:6px;" data-i18n="welcome.title">{l s='¡Bienvenido a WhatsBoost!' mod='whatsboost'}</h2>
  <p class="whatsboost-docs-desc" style="margin:0 0 10px;" data-i18n="welcome.desc">
    {l s='Convierte cada cambio de estado en una conversación. WhatsBoost envía WhatsApps automáticos cuando tu pedido avanza: recibido, en preparación, enviado… Tú decides el mensaje y el momento.' mod='whatsboost'}
  </p>

  <div class="whatsboost-docs-callout whatsboost-docs-callout--primary whatsboost-docs-callout--wide" style="margin-top:10px;">
    <div class="whatsboost-docs-flex">
      <div class="whatsboost-docs-col">
        <h3 class="whatsboost-docs-h2" style="margin:0 0 6px;" data-i18n="welcome.beauty.title">{l s='Lo bonito también funciona' mod='whatsboost'}</h3>
        <ul style="margin:0 0 8px 18px;list-style:disc;color:#475569">
          <li data-i18n="welcome.bullet.1">{l s='Mensajes claros, con datos reales del pedido (nombre, nº, estado, tracking…).' mod='whatsboost'}</li>
          <li data-i18n="welcome.bullet.2">{l s='Plantillas listas para usar y compatibles con todos los estados de PrestaShop.' mod='whatsboost'}</li>
          <li data-i18n="welcome.bullet.3">{l s='Entrega inmediata: tus clientes saben qué está pasando sin abrir el correo.' mod='whatsboost'}</li>
        </ul>
        <div style="display:flex;gap:8px;flex-wrap:wrap;margin-top:10px;">
          <a class="wb-btn wb-btn-primary" href="{$admin_base|escape:'htmlall':'UTF-8'}&wbv=settings" data-i18n="welcome.btn.settings">{l s='Ir a Ajustes' mod='whatsboost'}</a>
          <a class="wb-btn wb-btn-secondary" href="{$admin_base|escape:'htmlall':'UTF-8'}&wbv=states" data-i18n="welcome.btn.states">{l s='Estados y pedidos' mod='whatsboost'}</a>
          <a class="wb-btn wb-btn-secondary" href="{$admin_base|escape:'htmlall':'UTF-8'}&wbv=docs" data-i18n="welcome.btn.docs">{l s='Ver Documentos' mod='whatsboost'}</a>
        </div>
      </div>
    </div>
  </div>

  <div class="wb-card" style="margin-top:12px;">
    <h3 class="whatsboost-docs-h2" style="margin:0 0 8px;" data-i18n="welcome.steps.title">{l s='Arranca en 3 pasos' mod='whatsboost'}</h3>
    <ol class="wb-stepper">
      <li data-i18n="welcome.steps.1">{l s='Crea tu clave en WhatsBoost y cópiala.' mod='whatsboost'} <a href="https://whatsboost.net/dashboard/tools/keys" target="_blank" rel="noopener noreferrer" data-i18n="welcome.steps.1.link">{l s='Abrir claves API' mod='whatsboost'}</a></li>
      <li data-i18n="welcome.steps.2">{l s='Pégala en Ajustes y verifica. Te proponemos el número de WhatsApp disponible.' mod='whatsboost'}</li>
      <li data-i18n="welcome.steps.3">{l s='Activa los estados que quieras y personaliza el texto a tu estilo.' mod='whatsboost'}</li>
    </ol>
    <div style="margin-top:8px;">
      <a class="wb-btn wb-btn-primary" href="{$admin_base|escape:'htmlall':'UTF-8'}&wbv=settings" data-i18n="welcome.cta.configure">{l s='Configurar ahora' mod='whatsboost'}</a>
    </div>
  </div>

  <div class="whatsboost-docs-callout wb-tipcard" style="margin-top:12px;">
    <p class="whatsboost-docs-desc" style="margin:0;">
      <strong data-i18n="welcome.tip.label">{l s='Consejo:' mod='whatsboost'}</strong>
      <span data-i18n="welcome.tip.text">{l s='Empieza con 2–3 estados clave (Pedido confirmado y Enviado). Mide la respuesta y ve ampliando. Menos es más.' mod='whatsboost'}</span>
    </p>
  </div>
</div>

{literal}
<script>
(function(){
  try{
    var lang = (document.documentElement.getAttribute('lang')||'').toLowerCase();
    if(lang.indexOf('en') !== 0){ return; }
    var t = {
      'welcome.title': 'Welcome to WhatsBoost!',
      'welcome.desc': 'Turn every status change into a conversation. WhatsBoost sends automatic WhatsApps when your order progresses: received, in preparation, shipped… You choose the message and the timing.',
      'welcome.beauty.title': 'Beautiful also means functional',
      'welcome.bullet.1': 'Clear messages with real order data (name, number, status, tracking…).',
      'welcome.bullet.2': 'Ready-to-use templates compatible with all PrestaShop states.',
      'welcome.bullet.3': 'Instant delivery: your customers know what’s happening without opening email.',
      'welcome.btn.settings': 'Go to Settings',
      'welcome.btn.states': 'States and orders',
      'welcome.btn.docs': 'View Documents',
      'welcome.steps.title': 'Start in 3 steps',
      'welcome.steps.1': 'Create your key in WhatsBoost and copy it. ',
      'welcome.steps.1.link': 'Open API keys',
      'welcome.steps.2': 'Paste it in Settings and verify. We will propose the available WhatsApp number.',
      'welcome.steps.3': 'Enable the states you want and customize the text to your style.',
      'welcome.cta.configure': 'Configure now',
      'welcome.tip.label': 'Tip:',
      'welcome.tip.text': 'Start with 2–3 key states (Order confirmed and Shipped). Measure the response and expand. Less is more.'
    };
    var scope = document.querySelector('.whatsboost-welcome') || document;
    scope.querySelectorAll('[data-i18n]').forEach(function(el){
      var k = el.getAttribute('data-i18n');
      if(t[k]){ el.textContent = t[k]; }
    });
  }catch(e){}
})();
</script>
{/literal}

