<?php
if (!defined('ABSPATH')) { exit; }
?>
<div class="whatsboost-footer" role="contentinfo">
    <div class="whatsboost-footer-left">
        <img class="whatsboost-footer-logo" src="<?php echo esc_url(WHATSBOOST_URL . 'assets/img/almc-logo.webp'); ?>" alt="<?php echo esc_attr__('ALMC logo', 'whatsboost'); ?>">
    </div>
    <nav class="whatsboost-footer-links" aria-label="<?php echo esc_attr__('Enlaces de pie de página', 'whatsboost'); ?>">
        <?php
        $locale = function_exists('determine_locale') ? determine_locale() : get_locale();
        $is_en  = (stripos((string)$locale, 'en_') === 0);

        // Enlaces solicitados (respetando el mapeo proporcionado)
        // Nosotros: es -> en/sobre-nosotros, en -> es/sobre-nosotros (tal como indicó el requerimiento)
        $url_nosotros = $is_en ? 'https://almc.es/es/sobre-nosotros' : 'https://almc.es/en/sobre-nosotros';
        // Política de privacidad: es/en normales
        $url_priv     = $is_en ? 'https://almc.es/en/privacidad' : 'https://almc.es/es/privacidad';
        // Términos del servicio: es/en normales
        $url_terms    = $is_en ? 'https://almc.es/en/terminos-condiciones' : 'https://almc.es/es/terminos-condiciones';
        ?>
        <a href="<?php echo esc_url($url_nosotros); ?>" target="_blank" rel="noopener noreferrer"><?php echo esc_html__('Nosotros', 'whatsboost'); ?></a>
        <span class="sep" aria-hidden="true">•</span>
        <a href="<?php echo esc_url($url_priv); ?>" target="_blank" rel="noopener noreferrer"><?php echo esc_html__('Política de privacidad', 'whatsboost'); ?></a>
        <span class="sep" aria-hidden="true">•</span>
        <a href="<?php echo esc_url($url_terms); ?>" target="_blank" rel="noopener noreferrer"><?php echo esc_html__('Términos del servicio', 'whatsboost'); ?></a>
    </nav>
</div>
