<?php
if (!defined('ABSPATH')) { exit; }

?>
<div class="wrap">
  <?php include WHATSBOOST_DIR . 'includes/admin-views/partials/header.php'; ?>
  <h1><?php echo esc_html__('Configuración', 'whatsboost'); ?></h1>
  <p><?php echo esc_html__('Tu clave ha sido verificada correctamente. ¡Ya puedes usar el plugin WhatsBoost!', 'whatsboost'); ?></p>

  <?php if (isset($_GET['settings-updated']) && $_GET['settings-updated']) : ?>
    <div class="notice notice-success is-dismissible"><p><?php echo esc_html__('Guardado correctamente.', 'whatsboost'); ?></p></div>
  <?php endif; ?>

  <hr style="margin:18px 0;" />
  <h2><?php echo esc_html__('Bienvenido WhatsBoost', 'whatsboost'); ?></h2>
  <div class="notice notice-info" style="margin-top:10px;">
    <p style="font-size:14px;">
      <?php echo esc_html__('Cómo funciona esta página: aquí puedes decidir en qué estados de pedido quieres que se envíen mensajes por WhatsApp y qué texto se enviará. Es muy fácil, incluso si nunca has usado algo así.', 'whatsboost'); ?>
    </p>
    <ol style="margin-left:20px;">
      <li><?php echo esc_html__('Marca (activa) los estados de pedido donde quieres enviar el mensaje. Por ejemplo: Procesando, Completado, etc.', 'whatsboost'); ?></li>
      <li><?php echo esc_html__('Escribe el mensaje en la caja de texto de cada estado. Puedes usar etiquetas como {nombre}, {producto_pedido}, {precio}… Estas etiquetas se cambiarán automáticamente por los datos reales del pedido.', 'whatsboost'); ?></li>
      <li><?php echo esc_html__('Pulsa en Guardar cambios al final para que todo se quede guardado.', 'whatsboost'); ?></li>
      <li><?php echo esc_html__('Cuando un pedido cambie a ese estado, el plugin preparará el mensaje con los datos reales y lo enviará por WhatsApp (según tu configuración).', 'whatsboost'); ?></li>
    </ol>
    <p style="font-size:13px; color:#444; margin-top:8px;">
      <?php echo esc_html__('Consejo: a la derecha tienes un listado de etiquetas con un botón de copiar. Pulsa copiar y pega la etiqueta en tu mensaje.', 'whatsboost'); ?>
    </p>
  </div>

  <?php if (!function_exists('wc_get_order_statuses')) : ?>
    <div class="notice notice-warning"><p><?php echo esc_html__('WooCommerce no está activo. Instálalo y actívalo para ver los estados de pedido.', 'whatsboost'); ?></p></div>
  <?php else : ?>
    <?php
    // Obtener todos los estados de pedido y opciones guardadas
    $statuses = wc_get_order_statuses(); // ['wc-pending' => 'Pending payment', ...]
    $enabled  = get_option('whatsboost_status_enabled', []);
    $texts    = get_option('whatsboost_status_text', []);
    if (!is_array($enabled)) { $enabled = []; }
    if (!is_array($texts)) { $texts = []; }
    ?>

    <div class="whatsboost-flex" style="display:flex; gap:20px; align-items:flex-start; flex-wrap:wrap;">
      <div class="whatsboost-left" style="flex:1 1 650px; min-width:320px;">
        <form method="post" action="options.php">
          <?php settings_fields('whatsboost_status_group'); ?>
          <table class="widefat fixed striped" style="max-width:100%;">
            <thead>
              <tr>
                <th style="width:220px;"><?php echo esc_html__('Nombre', 'whatsboost'); ?></th>
                <th style="width:120px;"><?php echo esc_html__('Estado', 'whatsboost'); ?></th>
                <th><?php echo esc_html__('Texto', 'whatsboost'); ?></th>
              </tr>
            </thead>
            <tbody>
            <?php foreach ($statuses as $key => $label): ?>
              <?php
                $field_key = sanitize_key($key);
                $is_checked = !empty($enabled[$field_key]);
                $saved_text = isset($texts[$field_key]) ? (string) $texts[$field_key] : '';
              ?>
              <tr>
                <td><strong><?php echo esc_html($label); ?></strong> <code style="opacity:.7;">(<?php echo esc_html($key); ?>)</code></td>
                <td style="text-align:center;">
                  <label>
                    <input type="checkbox" name="whatsboost_status_enabled[<?php echo esc_attr($field_key); ?>]" value="1" <?php checked($is_checked, true); ?>>
                  </label>
                </td>
                <td>
                  <textarea name="whatsboost_status_text[<?php echo esc_attr($field_key); ?>]" rows="3" style="width:100%;min-height:90px;" placeholder="<?php echo esc_attr__('Escribe aquí el texto para este estado…', 'whatsboost'); ?>"><?php echo esc_textarea($saved_text); ?></textarea>
                </td>
              </tr>
            <?php endforeach; ?>
            </tbody>
          </table>
          <?php submit_button( esc_html__('Guardar cambios', 'whatsboost') ); ?>
        </form>
      </div>

      <aside class="whatsboost-right" style="flex:0 0 360px; min-width:280px; max-width:420px; position:sticky; top:20px; align-self:flex-start;">
        <div style="border:1px solid #ccd0d4; background:#fff; border-radius:6px; padding:14px;">
          <h3 style="margin-top:0;"><?php echo esc_html__('Ayuda rápida: etiquetas y botón de copiar', 'whatsboost'); ?></h3>
          <p style="margin:8px 0 12px;"><?php echo esc_html__('Abajo tienes todas las etiquetas explicadas. Para copiar una, pulsa el botón pequeño con el icono de copiar y luego pégala en el texto de la izquierda. El plugin la cambia por el dato real al enviar.', 'whatsboost'); ?></p>

          <ul class="mi-tags-list" style="margin:0 0 12px 0; padding:0; list-style:none; display:flex; flex-direction:column; gap:6px;">
            <li style="display:flex; align-items:center; justify-content:space-between; gap:8px;">
              <div><code>{nombre}</code> — <?php echo esc_html__('Nombre del cliente.', 'whatsboost'); ?></div>
              <button type="button" class="button button-small mi-copy" data-tag="{nombre}" aria-label="<?php echo esc_attr( sprintf( esc_attr__('Copiar %s', 'whatsboost'), '{nombre}' ) ); ?>">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true" focusable="false" style="vertical-align:middle;"><path d="M16 1H6a2 2 0 0 0-2 2v12h2V3h10V1zm4 4H10a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2zm0 16H10V7h10v14z"></path></svg>
               </button>
             </li>
            <li style="display:flex; align-items:center; justify-content:space-between; gap:8px;">
              <div><code>{apellido}</code> — <?php echo esc_html__('Apellido del cliente.', 'whatsboost'); ?></div>
              <button type="button" class="button button-small mi-copy" data-tag="{apellido}" aria-label="<?php echo esc_attr( sprintf( esc_attr__('Copiar %s', 'whatsboost'), '{apellido}' ) ); ?>">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true" focusable="false" style="vertical-align:middle;"><path d="M16 1H6a2 2 0 0 0-2 2v12h2V3h10V1zm4 4H10a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2zm0 16H10V7h10v14z"></path></svg>
               </button>
             </li>
            <li style="display:flex; align-items:center; justify-content:space-between; gap:8px;">
              <div><code>{producto_pedido}</code> — <?php echo esc_html__('Nombre del primer producto del pedido.', 'whatsboost'); ?></div>
              <button type="button" class="button button-small mi-copy" data-tag="{producto_pedido}" aria-label="<?php echo esc_attr( sprintf( esc_attr__('Copiar %s', 'whatsboost'), '{producto_pedido}' ) ); ?>">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true" focusable="false" style="vertical-align:middle;"><path d="M16 1H6a2 2 0 0 0-2 2v12h2V3h10V1zm4 4H10a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2zm0 16H10V7h10v14z"></path></svg>
               </button>
             </li>
            <li style="display:flex; align-items:center; justify-content:space-between; gap:8px;">
              <div><code>{cantidad}</code> — <?php echo esc_html__('Cantidad del primer producto.', 'whatsboost'); ?></div>
              <button type="button" class="button button-small mi-copy" data-tag="{cantidad}" aria-label="<?php echo esc_attr( sprintf( esc_attr__('Copiar %s', 'whatsboost'), '{cantidad}' ) ); ?>">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true" focusable="false" style="vertical-align:middle;"><path d="M16 1H6a2 2 0 0 0-2 2v12h2V3h10V1zm4 4H10a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2zm0 16H10V7h10v14z"></path></svg>
               </button>
             </li>
            <li style="display:flex; align-items:center; justify-content:space-between; gap:8px;">
              <div><code>{precio}</code> — <?php echo esc_html__('Total del pedido con moneda.', 'whatsboost'); ?></div>
              <button type="button" class="button button-small mi-copy" data-tag="{precio}" aria-label="<?php echo esc_attr( sprintf( esc_attr__('Copiar %s', 'whatsboost'), '{precio}' ) ); ?>">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true" focusable="false" style="vertical-align:middle;"><path d="M16 1H6a2 2 0 0 0-2 2v12h2V3h10V1zm4 4H10a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2zm0 16H10V7h10v14z"></path></svg>
               </button>
             </li>
            <li style="display:flex; align-items:center; justify-content:space-between; gap:8px;">
              <div><code>{plazo}</code> — <?php echo esc_html__('Método de envío o plazo.', 'whatsboost'); ?></div>
              <button type="button" class="button button-small mi-copy" data-tag="{plazo}" aria-label="<?php echo esc_attr( sprintf( esc_attr__('Copiar %s', 'whatsboost'), '{plazo}' ) ); ?>">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true" focusable="false" style="vertical-align:middle;"><path d="M16 1H6a2 2 0 0 0-2 2v12h2V3h10V1zm4 4H10a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2zm0 16H10V7h10v14z"></path></svg>
               </button>
             </li>
            <li style="display:flex; align-items:center; justify-content:space-between; gap:8px;">
              <div><code>{tienda}</code> — <?php echo esc_html__('Nombre de tu tienda o marca.', 'whatsboost'); ?></div>
              <button type="button" class="button button-small mi-copy" data-tag="{tienda}" aria-label="<?php echo esc_attr( sprintf( esc_attr__('Copiar %s', 'whatsboost'), '{tienda}' ) ); ?>">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true" focusable="false" style="vertical-align:middle;"><path d="M16 1H6a2 2 0 0 0-2 2v12h2V3h10V1zm4 4H10a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2zm0 16H10V7h10v14z"></path></svg>
               </button>
             </li>
            <li style="display:flex; align-items:center; justify-content:space-between; gap:8px;">
              <div><code>{link}</code> — <?php echo esc_html__('Enlace para ver el pedido.', 'whatsboost'); ?></div>
              <button type="button" class="button button-small mi-copy" data-tag="{link}" aria-label="<?php echo esc_attr( sprintf( esc_attr__('Copiar %s', 'whatsboost'), '{link}' ) ); ?>">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true" focusable="false" style="vertical-align:middle;"><path d="M16 1H6a2 2 0 0 0-2 2v12h2V3h10V1zm4 4H10a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2zm0 16H10V7h10v14z"></path></svg>
               </button>
             </li>
            <li style="display:flex; align-items:center; justify-content:space-between; gap:8px;">
              <div><code>{order_number}</code> — <?php echo esc_html__('Número del pedido (p. ej., #123).', 'whatsboost'); ?></div>
              <button type="button" class="button button-small mi-copy" data-tag="{order_number}" aria-label="<?php echo esc_attr( sprintf( esc_attr__('Copiar %s', 'whatsboost'), '{order_number}' ) ); ?>">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true" focusable="false" style="vertical-align:middle;"><path d="M16 1H6a2 2 0 0 0-2 2v12h2V3h10V1zm4 4H10a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2zm0 16H10V7h10v14z"></path></svg>
               </button>
             </li>
            <li style="display:flex; align-items:center; justify-content:space-between; gap:8px;">
              <div><code>{tracking}</code> — <?php echo esc_html__('Enlace o código de seguimiento (si existe).', 'whatsboost'); ?></div>
              <button type="button" class="button button-small mi-copy" data-tag="{tracking}" aria-label="<?php echo esc_attr( sprintf( esc_attr__('Copiar %s', 'whatsboost'), '{tracking}' ) ); ?>">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true" focusable="false" style="vertical-align:middle;"><path d="M16 1H6a2 2 0 0 0-2 2v12h2V3h10V1zm4 4H10a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2zm0 16H10V7h10v14z"></path></svg>
               </button>
             </li>
           </ul>

          <h4 style="margin:12px 0 6px;"><?php echo esc_html__('Reglas rápidas', 'whatsboost'); ?></h4>
          <ul style="margin:0 0 12px 18px; list-style:disc;">
            <li><?php echo esc_html__('No uses corchetes [ ]. Usa llaves { }.', 'whatsboost'); ?></li>
            <li><?php echo esc_html__('No dejes llaves vacías. Si no tienes el dato, borra esa parte.', 'whatsboost'); ?></li>
            <li><?php echo wp_kses_post( '<code>{link}</code> ' . esc_html__('debe abrir correctamente.', 'whatsboost') ); ?></li>
          </ul>

          <h4 style="margin:12px 0 6px;"><?php echo esc_html__('Ejemplo mínimo (lo que escribes)', 'whatsboost'); ?></h4>
          <textarea readonly style="width:100%; min-height:60px; font-family:monospace;" onclick="this.select();"><?php echo esc_html__('Hola {nombre} 👋 Tu {producto_pedido} (x{cantidad}) está en proceso. Mira aquí: {link}', 'whatsboost'); ?></textarea>

          <h4 style="margin:12px 0 6px;"><?php echo esc_html__('Resultado de ese ejemplo (lo que verá el cliente)', 'whatsboost'); ?></h4>
          <textarea readonly style="width:100%; min-height:60px; font-family:monospace; background:#f8f9fa;" onclick="this.select();"><?php echo esc_html__('Hola Laura 👋 Tu guantes térmicos (x2) está en proceso. Mira aquí: https://mi-tienda.com/pedido/123', 'whatsboost'); ?></textarea>
        <style>
           .whatsboost-right .mi-copy.is-copied { background-color:#22c55e; border-color:#22c55e; color:#fff; }
           .whatsboost-right .mi-copy.is-copied svg { color:#fff; fill:currentColor; }
         </style>
         </div>

         <script>
        (function(){
          var root = document.querySelector('.whatsboost-right');
          if (!root) return;
          var btns = root.querySelectorAll('.mi-copy');
          btns.forEach(function(b){
            b.addEventListener('click', function(){
              var t = b.getAttribute('data-tag') || '';
              if (!t) { return; }
              if (navigator.clipboard && navigator.clipboard.writeText) {
                navigator.clipboard.writeText(t).then(function(){
                  flash(b);
                }).catch(function(){
                  fallbackCopy(t, b);
                });
              } else {
                fallbackCopy(t, b);
              }
            });
          });

          function fallbackCopy(text, el){
            var ok = false;
            var ta = document.createElement('textarea');
            ta.value = text;
            ta.setAttribute('readonly', '');
            ta.style.position = 'fixed';
            ta.style.top = '-9999px';
            ta.style.opacity = '0';
            document.body.appendChild(ta);
            ta.focus();
            ta.select();
            try {
              ta.setSelectionRange(0, ta.value.length);
            } catch(e) {}
            try {
              ok = document.execCommand('copy');
            } catch(e) {
              ok = false;
            }
            document.body.removeChild(ta);
            if (ok) {
              flash(el);
            } else {
              // Último recurso: mostrar prompt para copiar manualmente
              window.prompt('Copia esta etiqueta:', text);
            }
          }

          function flash(el){
            var origHTML = el.getAttribute('data-orig') || el.innerHTML;
            el.setAttribute('data-orig', origHTML);
            el.classList.add('is-copied');
            // Mostrar solo un tick ✓ y cambiar color mediante la clase is-copied
            el.innerHTML = '✓';
            setTimeout(function(){
              el.innerHTML = el.getAttribute('data-orig');
              el.classList.remove('is-copied');
            }, 1000);
          }
        })();
        </script>
      </aside>
    </div>
  <?php endif; ?>
    <?php include WHATSBOOST_DIR . 'includes/admin-views/partials/footer.php'; ?>
</div>
