<?php
// Simple PO -> MO compiler script (based on the plugin's compile_po_to_mo implementation)
if ($argc < 3) {
    fwrite(STDERR, "Usage: php compile_po.php input.po output.mo\n");
    exit(2);
}
$poFile = $argv[1];
$moFile = $argv[2];
if (!is_readable($poFile)) { fwrite(STDERR, "PO file not readable: $poFile\n"); exit(3); }
$contents = file_get_contents($poFile);
$lines = preg_split('/\r?\n/', $contents);
$entries = [];
$state = null;
$cur = ['msgid' => '', 'msgstr' => ''];
foreach ($lines as $line) {
    $line = trim($line);
    if ($line === '' || strpos($line, '#') === 0) {
        if ($cur['msgid'] !== '' || $cur['msgstr'] !== '') {
            $entries[] = $cur;
            $cur = ['msgid' => '', 'msgstr' => ''];
            $state = null;
        }
        continue;
    }
    if (preg_match('/^msgid\s+"(.*)"$/', $line, $m)) { $state = 'msgid'; $cur['msgid'] = stripcslashes($m[1]); continue; }
    if (preg_match('/^msgstr\s+"(.*)"$/', $line, $m)) { $state = 'msgstr'; $cur['msgstr'] = stripcslashes($m[1]); continue; }
    if (preg_match('/^"(.*)"$/', $line, $m)) { if ($state && isset($cur[$state])) { $cur[$state] .= stripcslashes($m[1]); } continue; }
}
if ($cur['msgid'] !== '' || $cur['msgstr'] !== '') { $entries[] = $cur; }
$trans = [];
foreach ($entries as $e) {
    $id = $e['msgid'];
    $str = $e['msgstr'];
    if ($id === '') { continue; }
    $trans[$id] = $str;
}
if (empty($trans)) { fwrite(STDERR, "No translations found in $poFile\n"); exit(4); }
ksort($trans);
$ids = array_keys($trans);
$strings = array_values($trans);
$idsBuf = '';
$stringsBuf = '';
foreach ($ids as $id) { $idsBuf .= $id . "\0"; }
foreach ($strings as $s) { $stringsBuf .= $s . "\0"; }
$originals = [];
$translations = [];
$curIdOffset = 0;
foreach ($ids as $id) { $len = strlen($id); $originals[] = [$len, $curIdOffset]; $curIdOffset += $len + 1; }
$curStrOffset = 0;
foreach ($strings as $s) { $len = strlen($s); $translations[] = [$len, $curStrOffset]; $curStrOffset += $len + 1; }
$idsLen = strlen($idsBuf);
$stringsLen = strlen($stringsBuf);
$n = count($originals);
$origTableOffset = 28;
$transTableOffset = $origTableOffset + ($n * 8);
$idsOffset = $transTableOffset + ($n * 8);
$stringsOffset = $idsOffset + $idsLen;
$f = function($v){ return pack('V', $v); };
$magic = 0x950412de;
$of = fopen($moFile, 'wb');
if (!$of) { fwrite(STDERR, "Cannot open MO for writing: $moFile\n"); exit(5); }
fwrite($of, $f($magic));
fwrite($of, $f(0));
fwrite($of, $f($n));
fwrite($of, $f($origTableOffset));
fwrite($of, $f($transTableOffset));
fwrite($of, $f(0));
$cur = $idsOffset;
for ($i = 0; $i < $n; $i++) {
    fwrite($of, $f($originals[$i][0]));
    fwrite($of, $f($cur));
    $cur += $originals[$i][0] + 1;
}
$cur = $stringsOffset;
for ($i = 0; $i < $n; $i++) {
    fwrite($of, $f($translations[$i][0]));
    fwrite($of, $f($cur));
    $cur += $translations[$i][0] + 1;
}
fwrite($of, $idsBuf);
fwrite($of, $stringsBuf);
fclose($of);
fwrite(STDOUT, "Wrote mo: $moFile\n");
exit(0);

